(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 4.2'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      5679,        261]*)
(*NotebookOutlinePosition[      6316,        283]*)
(*  CellTagsIndexPosition[      6272,        279]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["Example 2.5", "Subtitle"],

Cell[BoxData[
    \(Clear[A, sys, r, p, v1, v2]\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"A", "=", 
      RowBox[{"(", GridBox[{
            {"6", "2"},
            {"3", "1"}
            }], ")"}]}]], "Input"],

Cell[BoxData[
    \({{6, 2}, {3, 1}}\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell["Alternate form of the problem", "Subsection"],

Cell[CellGroupData[{

Cell[BoxData[
    \(A . {x, y} \[Equal] r {x, y}\)], "Input"],

Cell[BoxData[
    \({6\ x + 2\ y, 3\ x + y} == {r\ x, r\ y}\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(LogicalExpand[A . {x, y} \[Equal] r {x, y}]\)], "Input"],

Cell[BoxData[
    \(3\ x + y == r\ y && 6\ x + 2\ y == r\ x\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(% /. And \[Rule] List // ColumnForm\)], "Input"],

Cell[BoxData[
    InterpretationBox[GridBox[{
          {\(3\ x + y == r\ y\)},
          {\(6\ x + 2\ y == r\ x\)}
          },
        GridBaseline->{Baseline, {1, 1}},
        ColumnAlignments->{Left}],
      ColumnForm[ {
        Equal[ 
          Plus[ 
            Times[ 3, x], y], 
          Times[ r, y]], 
        Equal[ 
          Plus[ 
            Times[ 6, x], 
            Times[ 2, y]], 
          Times[ r, x]]}],
      Editable->False]], "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Calculations", "Subsection"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\((sys[r_] = A - r*IdentityMatrix[2])\) // MatrixForm\)], "Input"],

Cell[BoxData[
    TagBox[
      RowBox[{"(", "\[NoBreak]", GridBox[{
            {\(6 - r\), "2"},
            {"3", \(1 - r\)}
            }], "\[NoBreak]", ")"}],
      Function[ BoxForm`e$, 
        MatrixForm[ BoxForm`e$]]]], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(p[r_] = Det[sys[r]]\)], "Input"],

Cell[BoxData[
    \(\(-7\)\ r + r\^2\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Solve[p[r] \[Equal] 0]\)], "Input"],

Cell[BoxData[
    \({{r \[Rule] 0}, {r \[Rule] 7}}\)], "Output"]
}, Closed]],

Cell["The two characteristic roots.", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \({r1, r2} = r /. Solve[p[r] \[Equal] 0]\)], "Input"],

Cell[BoxData[
    \({0, 7}\)], "Output"]
}, Closed]],

Cell["The characteristic vector corresponding to r1.", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(v1 = \(NullSpace[sys[r1]]\)[\([1]\)]\)], "Input"],

Cell[BoxData[
    \({\(-1\), 3}\)], "Output"]
}, Closed]],

Cell["Check.", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(A . v1 \[Equal] r1*v1\)], "Input"],

Cell[BoxData[
    \(True\)], "Output"]
}, Closed]],

Cell["The characteristic vector corresponding to r2.", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(v2 = \(NullSpace[sys[r2]]\)[\([1]\)]\)], "Input"],

Cell[BoxData[
    \({2, 1}\)], "Output"]
}, Closed]],

Cell["Check.", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(A . v2 \[Equal] r2*v2\)], "Input"],

Cell[BoxData[
    \(True\)], "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Using Eigensystem", "Subsection"],

Cell[CellGroupData[{

Cell[BoxData[
    \({vals, vecs} = Eigensystem[A]\)], "Input"],

Cell[BoxData[
    \({{0, 7}, {{\(-1\), 3}, {2, 1}}}\)], "Output"]
}, Closed]],

Cell["\<\
We could now obtain both the characteristic values and the \
characteristic vectors this way:\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \({r1, r2} = vals\)], "Input"],

Cell[BoxData[
    \({0, 7}\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \({v1, v2} = vecs\)], "Input"],

Cell[BoxData[
    \({{\(-1\), 3}, {2, 1}}\)], "Output"]
}, Closed]],

Cell["Check both pairs {r1, v1} and {r2, v2}.", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(A . v1 \[Equal] r1*v1 && A . v2 \[Equal] r2*v2\)], "Input"],

Cell[BoxData[
    \(True\)], "Output"]
}, Closed]]
}, Closed]]
}, Open  ]]
},
FrontEndVersion->"4.2 for Macintosh",
ScreenRectangle->{{4, 1024}, {0, 746}},
WindowSize->{520, 624},
WindowMargins->{{44, Automatic}, {Automatic, 13}}
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 31, 0, 65, "Subtitle"],
Cell[1810, 55, 60, 1, 27, "Input"],

Cell[CellGroupData[{
Cell[1895, 60, 147, 5, 41, "Input"],
Cell[2045, 67, 50, 1, 27, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[2132, 73, 51, 0, 30, "Subsection"],

Cell[CellGroupData[{
Cell[2208, 77, 61, 1, 27, "Input"],
Cell[2272, 80, 73, 1, 27, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[2382, 86, 76, 1, 27, "Input"],
Cell[2461, 89, 73, 1, 27, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[2571, 95, 68, 1, 27, "Input"],
Cell[2642, 98, 465, 17, 42, "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[3156, 121, 34, 0, 30, "Subsection"],

Cell[CellGroupData[{
Cell[3215, 125, 86, 1, 27, "Input"],
Cell[3304, 128, 239, 7, 53, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[3580, 140, 52, 1, 27, "Input"],
Cell[3635, 143, 50, 1, 29, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[3722, 149, 55, 1, 27, "Input"],
Cell[3780, 152, 64, 1, 27, "Output"]
}, Closed]],
Cell[3859, 156, 45, 0, 32, "Text"],

Cell[CellGroupData[{
Cell[3929, 160, 71, 1, 27, "Input"],
Cell[4003, 163, 40, 1, 27, "Output"]
}, Closed]],
Cell[4058, 167, 62, 0, 32, "Text"],

Cell[CellGroupData[{
Cell[4145, 171, 69, 1, 27, "Input"],
Cell[4217, 174, 45, 1, 27, "Output"]
}, Closed]],
Cell[4277, 178, 22, 0, 32, "Text"],

Cell[CellGroupData[{
Cell[4324, 182, 54, 1, 27, "Input"],
Cell[4381, 185, 38, 1, 27, "Output"]
}, Closed]],
Cell[4434, 189, 62, 0, 32, "Text"],

Cell[CellGroupData[{
Cell[4521, 193, 69, 1, 27, "Input"],
Cell[4593, 196, 40, 1, 27, "Output"]
}, Closed]],
Cell[4648, 200, 22, 0, 32, "Text"],

Cell[CellGroupData[{
Cell[4695, 204, 54, 1, 27, "Input"],
Cell[4752, 207, 38, 1, 27, "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[4839, 214, 39, 0, 30, "Subsection"],

Cell[CellGroupData[{
Cell[4903, 218, 62, 1, 27, "Input"],
Cell[4968, 221, 65, 1, 27, "Output"]
}, Closed]],
Cell[5048, 225, 117, 3, 32, "Text"],

Cell[CellGroupData[{
Cell[5190, 232, 48, 1, 27, "Input"],
Cell[5241, 235, 40, 1, 27, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[5318, 241, 48, 1, 27, "Input"],
Cell[5369, 244, 55, 1, 27, "Output"]
}, Closed]],
Cell[5439, 248, 55, 0, 32, "Text"],

Cell[CellGroupData[{
Cell[5519, 252, 79, 1, 27, "Input"],
Cell[5601, 255, 38, 1, 27, "Output"]
}, Closed]]
}, Closed]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

